<?php
/**
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * index.php
 * 
 * @category     Core
 * @package      Core_Environment
 * @subpackage   Installer
 * @author       Dietmar Wöllbrink <dietmar.woellbrink@websitebaker.org>
 * @copyright    Werner v.d.Decken <wkl@isteam.de>
 * @license      http://www.gnu.org/licenses/gpl.html   GPL License
 * @version      0.0.2
 * @revision     $Revision: 2030 $
 * @link         $HeadURL: svn://isteam.dynxs.de/wb_svn/wb280/branches/2.8.x/wb/install/index.php $
 * @lastmodified $Date: 2013-12-14 20:42:00 +0100 (Sa, 14. Dez 2013) $
 * @since        File available since 2012-04-01
 * @description  xyz
 */
 error_reporting(0);
// Start a session
if(!defined('SESSION_STARTED')) {
	session_name('wb_session_id');
	session_start();
	define('SESSION_STARTED', true);
}

$sDocRoot = str_replace('\\','/',rtrim(realpath($_SERVER['DOCUMENT_ROOT']),'/').'/');
$sAppAbsRoot  = str_replace('\\','/',rtrim((dirname(realpath( __FILE__))),'/')).'/';
$sAppRelRoot  = str_replace(($sDocRoot),'',$sAppAbsRoot);
// Function to highlight input fields which contain wrong/missing data
function field_error($field_name='') {
	if(!defined('SESSION_STARTED') || $field_name == '') return;
	if(isset($_SESSION['ERROR_FIELD']) && $_SESSION['ERROR_FIELD'] == $field_name) {
		return ' class="wrong"';
	}
}
error_reporting(E_ALL ^ E_NOTICE);
$installFlag = true;
// Check if the page has been reloaded
if(!isset($_GET['sessions_checked']) OR $_GET['sessions_checked'] != 'true') {
	// Set session variable
	$_SESSION['session_support'] = '<font class="good">Enabled</font>';
	// Reload page
	header('Location: check.php?sessions_checked=true');
	exit(0);
} else {
	// Check if session variable has been saved after reload
	if(isset($_SESSION['session_support'])) {
		$session_support = $_SESSION['session_support'];
	} else {
		$installFlag = false;
		$session_support = '<font class="bad">Disabled</font>';
	}
}
$getMagicQuotesGpc = '<font class="good">Off</font>';
if ( function_exists('get_magic_quotes_gpc')  && filter_var(strtolower(get_magic_quotes_gpc()), FILTER_VALIDATE_BOOLEAN ) ) {
    $getMagicQuotesGpc = '<font class="bad">On</font>';
    $installFlag = false;
}

// Check if AddDefaultCharset is set
$e_adc=false;
$sapi=php_sapi_name();
if(strpos($sapi, 'apache')!==FALSE || strpos($sapi, 'nsapi')!==FALSE) {
	flush();
	$apache_rheaders=apache_response_headers();
	foreach($apache_rheaders AS $h) {
		if(strpos($h, 'html; charset')!==FALSE) {
			preg_match('/charset\s*=\s*([a-zA-Z0-9- _]+)/', $h, $match);
			$apache_charset=$match[1];
			$e_adc=$apache_charset;
		}
	}
}

//$sapi_type = php_sapi_name();
if(!isset($_SESSION['operating_system'])) {
	$operating_system = ((strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? 'windows' : 'linux');
} else {
	$operating_system = $_SESSION['operating_system'];
}
    function hasInstallation()
	{
        $existing = null;
		if ($existing === null) {
			if ( (is_readable('config.php') && is_readable('setup.ini.php') )   ) {
				$existing = true;
			} elseif (is_readable('config.php') ) {
				$existing = true;
			} else {
				$existing = false;
			}
		}
		return $existing;
	}

    function readyInstallation()
	{
        $existing = null;
		if ($existing === null) {
			if ( (is_readable('config.php') && is_readable('setup.ini.php') )   ) {
				$existing = '<font class="good">WebsiteBaker ready for upgrading</font>';
			} elseif (is_readable('config.php') ) {
				$existing = '<font class="good">WebsiteBaker ready for upgrading</font>';
			} else {
				$existing = '<font class="good">WebsiteBaker ready for installation</font>';
			}
		}
		return $existing;
	}

    function checkExistingFolder($sFolderExists = '') 
    {
        if(is_writable($sFolderExists)){
            echo '<font class="good">Writeable</font>';            
        }
        
    }

    function canInstall()
	{
        if ( (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ) { return true;}
		// Try to create a folder
		if (@mkdir('test') === false) {
			return false;
		} else {
//			clearstatcache();
			$self = posix_getpwuid(@fileowner(dirname(__FILE__)));
			$test = posix_getpwuid(@fileowner('test'));
			@rmdir('test');

			if ($self != $test) {
				return false;
			}
		}

		// Try to create a file
		if (@file_put_contents('test.txt', '') === false) {
			return false;
		} else {
			clearstatcache();
			$self = posix_getpwuid(@fileowner(__FILE__));
			$test = posix_getpwuid(@fileowner('test.txt'));
			@unlink('test.txt');

			if ($self != $test) {
				return false;
			}
		}

		return true;
	}

function checkConfigFile ($sWbPath,$sType ) {
	$config = '';
	$sConfigContent	= "<?php\n";
	$sConfigFile = $sWbPath.$sType.'.php';

// config.php or config.php.new
		if ((file_exists($sConfigFile)==true)) {
// next operation only if file is writeable
			if (is_writeable($sConfigFile)) {
// already installed? it's not empty
				if (filesize($sConfigFile) > 100) {
					$config = '<font class="bad">WebsiteBaker Already installed? Check please!</font>';
// try to open and to write
				} elseif (!$handle = fopen($sConfigFile, 'w')) {
					$config = '<font class="bad">Not Writeable</font>';
				} else {
					if (fwrite($handle, $sConfigContent) === FALSE) {
						$config = '<font class="bad">Not Writeable</font>';
					} else {
						$config = '';
						$_SESSION[$sType.'_rename'] = true;
					}
					// Close file
					fclose($handle);
				}
			} else {
				$config = '<font class="bad">Not Writeable</font>';
			}
// it's config.php.new
		} elseif ((file_exists($sConfigFile.'.new')==true)) {
			$config = '<font class="bad">Please rename to '.$sType.'.php</font>';
		} else {
			$config = '<font class="bad">Missing!!?</font>';
		}
	return $config;
}

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<title>WebsiteBaker 2.8.4 Check Wizard</title>
<style type="text/css">
<!--
@charset "utf-8";
/* <![CDATA[ */
/*
*/
* { margin :0px auto; padding :0px; }
* html body * { overflow :visible; }
html { padding :0; margin :0; border :0; font-size :85%; font-family :Arial, Verdana, Helvetica, sans-serif; color :#202020; overflow :-moz-scrollbars-vertical; overflow-x :auto; }
table { font-size :1em; }
body { padding :0; border :0; margin :0; background :url('background.png') repeat-x 0px 0px; height :101%; background :#A8BCCB; }
div.body { width :800px; margin :1em auto; padding :20px 20px 5px 20px; border :solid 1px #305C8D; background :#FFFFFF; }
div.content { margin-top :20px; }
/*
	TABLE Elements
*/
table.layout { margin:0px auto; table-layout:fixed; empty-cells:show; border-collapse: collapse; border-spacing: 0px; width :100%; }
table.header { border-style :solid; border-width :1px; border-color :#A3BACA; background :#F8F8FF;  }
table { margin-top :15px; margin-bottom :5px; width :100%; border-style :solid; border-width :1px 2px 2px 1px; border-color :#A3BACA; background :#F8F8FF; }
	table > thead { background :#F2F1FF; }
		table > thead > tr { }
			table > thead > tr > th { color :#555758; font-size :1.15em; padding :1.2em 1em; }
			table > thead > tr > td { color :#555758; font-size :1.08em; padding :1.2em 1em; }
	table > tbody { display :block; }
		table > tbody > tr { border-bottom :1px solid #222222; /* #d2d1cc; */ padding :0.8em 0 0.2em 0; width :100%; }
			table > tbody > tr > th { font-size :1em; width :1%; padding-left :0.8em; padding-right :0.8em; vertical-align :top; text-align :right; white-space :nowrap; }
			table > tbody > tr > td { font-size :1em; width :20%; padding-left :0.8em; padding-right :0.8em; vertical-align :top; text-align :left; line-height :2em; }
td.step-row { line-height :3em; color :#666666; font-weight :bold; font-size :100%; }
td.name { width :180px; color :#666666; vertical-align :middle; font-weight :bold; font-size :90%; float :left; }
td.value { width :100%; vertical-align :middle; }
td.value input { width :100%; vertical-align :middle; }
h1.step-row { margin :0; display :inline; color :#6699FF; }
/*
	FORM Elements
*/
form { margin :0; }
input, select { padding :2px; border :solid 1px #A3BACA; }
input:focus, select:focus { background :#FDF8E8; }
input.submit { color :#305C8D; font-size :12px; font-weight :bold; text-transform :uppercase; letter-spacing :1px; padding :6px; margin :1em 0; cursor :pointer; border :outset 2px #008000; }
input.submit:hover { border-style :inset; }
input.submit.bad { border-color :#FF0000; background :#FDE8E8; }
input.submit.good { border-color :#008000; background :#DEFFDE; }
/*
	COMMON Elements
*/
img { border :none; }
p { margin :11px 0 4px 0; }
h1 { color :#3A628F; font-size :1.3em; margin :10px 0 5px; border-top :medium none; }
a, a:link, a:visited, a:active { color :#003366; text-decoration :underline; }
a:focus { outline :none; }
a:hover { color :#336699; }
/*
	HINTS
*/
.warning, .error { color :#B70000; line-height :1.2em; margin-top :0.5em; padding :0.3em 0.5em; border :solid 1px; background :#FDE8E8; }
.warning { color :#CA6800; }
.info { color :#063F16; line-height :1.2em; margin-top :0.5em; padding :0.3em 0.5em; border :solid 1px; background :#E2E7E7; }
.info { color :#0A4D2A; }

.bad { color :#B70000; font-weight: bold; }
.good { color :#118301; font-weight: bold; }
.warn { color :#CA6800; }
.hint { color :#464646; font-size :0.85em; }
.small { font-size :0.85em; }
.italic { font-style :italic; }
.center { text-align :center; }
.hide { display :none; }
/*
	List Elements
*/
ul { margin :0; padding :2px 0 2px 15px; }
li { list-style-type :square; margin :0; }
/* ************************************************************************** */
	
-->
</style>

<script type="text/javascript">

function confirm_link(message, url) {
	if(confirm(message)) location.href = url;
}
function change_os(type) {
	if(type == 'linux') {
		document.getElementById('operating_system_linux').checked = true;
		document.getElementById('operating_system_windows').checked = false;
		document.getElementById('file_perms_box').style.display = 'none';
	} else if(type == 'windows') {
		document.getElementById('operating_system_linux').checked = false;
		document.getElementById('operating_system_windows').checked = true;
		document.getElementById('file_perms_box').style.display = 'none';
	}
}
</script>
</head>
<body>
<div class="body">
<table class="header layout">
<tr style="background: #a9c9ea;">
	<td>
<?php $iSteps = 1 ?>
		<img src="templates/wb_theme/images/logo.png" style="width: 80%;" alt="WebsiteBaker" />
	</td>
	<td>
		<h1 style="border:none; margin:1em auto;font-size:150%;">WebsiteBaker 2.8.4 Check Wizard</h1>
	</td>
</tr>
</table>

<form name="website_baker_installation_wizard" action="check.php" method="post">
    <input type="hidden" name="url" value="" />

		<div style="padding: 5px; text-align: center; font-weight: bold;">
			Welcome to the WebsiteBaker 2.8.4 Install and Upgrade Check Wizard.
		</div>
		<?php
		if(isset($_SESSION['message']) AND $_SESSION['message'] != '') {
			?><div  style="width: 700px; padding: 10px; margin-bottom: 5px; border: 1px solid #FF0000; background-color: #FFDBDB;"><b>Error:</b> <?php echo $_SESSION['message']; ?></div><?php
		}
		?>
		<table>
		<tr>
			<td colspan="6" class="step-row"><h1 class="step-row">Step <?php echo $iSteps++; ?> </h1>&nbsp;Please check the following requirements are met before installing or upgrading...</td>
		</tr>
		<?php if($session_support != '<font class="good">Enabled</font>') { ?>
		<tr>
			<td colspan="6" class="error">Please note: PHP Session Support may appear disabled if your browser does not support cookies.</td>
		</tr>
		<?php } ?>
		<tr>
			<td style="color: #666666;">PHP Version 5.3.2+</td>
			<td>
				<?php
			   if (version_compare(PHP_VERSION, '5.3.2', '>='))
			   {
					?><font class="good"><?php print PHP_VERSION; ?></font><?php
				} else {
					$installFlag = false;
					?><font class="bad">No</font><?php
				}
				?>
			</td>
			<td style="color: #666666;">PHP Session Support</td>
			<td><?php echo $session_support; ?></td>
		</tr>
	<tr>
		<td style="color: #666666;">PHP Interface</td>
			<td>
				<?php
						?><font class="good">
						<?php echo $sapi ?>
						</font>
			</td>
		<td style="color: #666666;">magic_quotes_gpc</td>
			<td >
				<?php ?><font class="good">
						<?php echo $getMagicQuotesGpc ?>
						</font>
			</td>

		</tr>

		<tr>
		<td style="color: #666666;">Server DefaultCharset</td>
			<td>
				<?php
					$chrval = (($e_adc != '') && (strtolower($e_adc) != 'utf-8') ? true : false);
					if($chrval == false) {
						?><font class="good">
						<?php echo (($e_adc=='') ? 'OK' : $e_adc) ?>
						</font>
						<?php
					} else {
                        $installFlag = false;
						?><font class="bad"><?php echo $e_adc ?></font><?php
					}

				?>
			</td>
			<td style="color: #666666;">PHP Safe Mode</td>
			<td>
				<?php
				if(ini_get('safe_mode')=='' || strpos(strtolower(ini_get('safe_mode')), 'off')!==FALSE || ini_get('safe_mode')==0) {
					?><font class="good">Disabled</font><?php
				} else {
					$installFlag = false;
					?><font class="bad">Enabled</font><?php
				}
				?>
			</td>
		</tr>
		<?php if($chrval == true) {
		?>
		<tr>
			<td colspan="6" style="font-size: 10px;" class="bad">
<p class="warning">
<b>Please note:</b> Yor webserver is configured to deliver <b><?php echo $e_adc;?></b> charset only.<br />
To display national special characters (e.g.: &auml; &aacute;) in clear manner, switch off this preset please(or let it do by your hosting provider).<br />
In any case you can choose <b><?php echo $e_adc;?></b> in the settings of WebsiteBaker.<br />
But this solution does not guarranty a correct displaying of the content from all modules!
</p>
</td>
</tr>
<?php } ?>
<tr>
	<td style="line-height: 0.4em;" colspan="4">&nbsp;</td>
</tr>
</table>

<table>
<?php if ( hasInstallation() ) { ?>
    <tr>
		<td class="warning" colspan="6" style="width: 100%; color: #666666; font-weight: bold;">
        <p>
        NOTICE: Check only the Standard Packages folder. Renamed folder are displayed as Directory not found
        </p>
        </td>
    </tr>
    <tr>
    	<td colspan="6" class="step-row"><h1 class="step-row">Step <?php echo $iSteps++; ?> </h1>&nbsp;Please check the following files/folders are writeable before continuing...</td>
    </tr>
<?php

//$sDirNotFound  = '<font class="bad">Directory Not Found</font>';
//$sWriteable    = '<font class="good">Writeable</font>';
//$sUnwriteable  = '<font class="bad">Unwriteable</font>';


/**
 * checkAbsPath()
 * 
 * @param string $sAbsPath
 * @return string 
 */
function checkAbsPath( $sAbsPath = '') {
    global $installFlag;
    $sReturnVal = ''; 
    if( !@is_dir( $sAbsPath ) ) { 
        $installFlag = false;
        return '<font class="bad">Directory Not Found</font>'; 
    }   
    $sAbsPath = trim($sAbsPath).'/';
    if( @is_writable($sAbsPath)) {
        $sReturnVal = '<font class="good">Writeable</font>';
     } else {
        $sReturnVal = '<font class="bad">Unwriteable</font>';
        $installFlag = false;
    }
    return $sReturnVal;
}


?>
		<tr>
			<td style="width: 15%; color: #666666;"><?php print $sAppRelRoot ?>pages/</td>
			<td style="width: 35%;"><?php echo checkAbsPath('pages/'); ?>
            </td>
			<td style="width: 15%; color: #666666;"><?php print $sAppRelRoot ?>media/</td>
			<td style="width: 40%;"><?php echo checkAbsPath('media/'); ?></td>
		</tr>
		<tr>
			<td style="width: 15%; color: #666666;"><?php print $sAppRelRoot ?>templates/</td>
			<td style="width: 35%;"><?php echo checkAbsPath('templates/'); ?></td>
			<td style="color: #666666;"><?php print $sAppRelRoot ?>modules/</td>
			<td style="width: 40%;"><?php echo checkAbsPath('modules/'); ?></td>
		</tr>
		<tr>
			<td style="width: 15%; color: #666666;"><?php print $sAppRelRoot ?>languages/</td>
			<td style="width: 35%;"><?php echo checkAbsPath('languages/'); ?></td>
			<td style="width: 15%; color: #666666;"><?php print $sAppRelRoot ?>temp/</td>
			<td style="width: 40%;"><?php echo checkAbsPath('temp/'); ?></td>
		</tr>
		<tr>
			<td style="line-height: 0.4em;" colspan="2">&nbsp;</td>
			<td style="line-height: 0.4em;" colspan="1">&nbsp;</td>
			<td style="line-height: 0.4em;" colspan="1">&nbsp;</td>
			<td style="line-height: 0.4em;" colspan="2">&nbsp;</td>
		</tr>
<?php } ?>
	</table>
    
<table>

<tr>
	<td colspan="2" style="width: 100%; " class="step-row"><h1 class="step-row">Step <?php echo $iSteps++; ?> </h1>&nbsp;Type of working (upgrade or install)! Checked File and Folder Permissions</td>
</tr>
<?php
?>
	<tr>
		<td style="width: 20%; color: #666666;">Pre Check</td>
		<td style="width: 85%;"><?php print readyInstallation()  ?></td>
	</tr>
<?php
$msg = '';
if ( (canInstall()===true)  ) {
    $msg = '<font class="good">Creating Folder/Files succesfully done </font>';
    $bShowMsg = false;   
} else {
    $msg = '<font class="bad" style="color: #003366">Permission Error! Creating Folder/Files failed!</font>';;    
//	$installFlag = false;
    $bShowMsg = true;   

}

?>
<?php if ( $bShowMsg==true ) {  ?>
	<tr>
		<td  colspan="2" style="">
        <p style="width: 98%; text-align:left;font-weight: bold;" class="warning">
        NOTICE: <br />
WebsiteBaker needs to be able to write to several files and directories, 
which are listed in Installer Step 2. Sometimes, as different programs decompress, 
download and upload the installation files, they may change a file's or 
folder's permissions. So, if any of the items in Installer Step 2 is listed as "not writeable”, 
you must correct its permissions, so WB will be able to write to it.<br />
</p>
        </td>
	</tr>
<?php }  ?>
		<tr>
			<td style="width: 20%; color: #666666;">Check Rights</td>
			<td style="width: 85%;"><?php print $msg ?></td>
		</tr>

<?php if ( $bShowMsg==true ) {  ?>
	<tr>
		<td  colspan="2" style="">
        <p style="width: 98%; text-align:left;font-weight: bold;" class="warning">
        NOTICE: <br />
You should be able to correct the permissions of the items you just 
uploaded with your ftp client. Ftp clients usually allow you to set 
the permissions of any file or directory to which you have ftp access - usually 
by clicking on checkboxes for the right to “read”, “write” and “execute” the file, 
or simply by providing a code number which indicates the permission level.<br />        
</p>
        </td>
	</tr>
<?php }  ?>

</table>

<table>
		<?php if($installFlag == true) { ?> 
			<tr>
				<td><strong>Please note: &nbsp;</strong></td>
			</tr>
			<tr>
				<td>
					<p class="info">
					WebsiteBaker is released under the
					<a href="http://www.gnu.org/licenses/gpl.html" target="_blank" tabindex="19">GNU General Public License</a>
					<br />
					You must accept the license before upgrading or installing WebsiteBaker
					</p>
				</td>
			</tr>
		<?php } ?>
		<tr>
		<td>
			<p class="center">
				<?php if($installFlag == true) { 
                $sMessage = '';
    			if ( (is_readable('config.php') && is_readable('setup.ini.php') )   ) {
    				$sMessage = '<font class="good">WebsiteBaker 2.8.x is ready for upgrading to Version 2.8.4</font>';
    			} elseif (is_readable('config.php') ) {
    				$sMessage = '<font class="good">WebsiteBaker 2.8.x is ready for upgrading to Version 2.8.4</font>';
    			} else {
    				$sMessage = '<font class="good">WebsiteBaker 2.8.4 is ready for installation</font>';
    			}
                ?>
				<button type="submit" tabindex="20" name="restart" value="" style="width: 97%; height:80px; text-align:center;font-weight: bold;" ><h2><?php print $sMessage; ?></h2></button>
				<?php } else { ?>
				<input type="button" tabindex="20" name="restart" value="Check your Settings in Step1 or Step2" class="submit" onclick="javascript: window.location = '<?php print $_SERVER['SCRIPT_NAME'] ?>';" />
				<?php } ?>
			</p>
			</td>
		</tr>
		</table>

</form>

	<div style="padding: 10px 0px 10px 0px; text-align:center;">
		<!-- Please note: the below reference to the GNU GPL should not be removed, as it provides a link for users to read about warranty, etc. -->
		<a href="http://www.websitebaker.org/" style="color: #000000;" target="_blank">WebsiteBaker</a>
		is	released under the
		<a href="http://www.gnu.org/licenses/gpl.html" style="color: #000000;" target="_blank">GNU General Public License</a>
		<!-- Please note: the above reference to the GNU GPL should not be removed, as it provides a link for users to read about warranty, etc. -->
	</div >
</div>

</body>
</html>
